# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def serendipitous_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1  # 1-based index
    total_rounds = 10
    
    # Early phase: signal cooperation
    if current_round <= 3:
        if current_round == 1:
            return "C"
        # Check for unprovoked defection
        if opp_history[-1] == "D" and all(m == "C" for m in my_history):
            return "D"
        return "C"
    
    # Mid-game: analyze opponent's behavior
    opp_defections = opp_history.count("D")
    my_defections = my_history.count("D")
    
    # Check if opponent is always cooperating or defecting
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D"
    if is_always_d:
        return "C" if current_round % 2 == 0 else "D"
    
    # Tit-for-tat if opponent defects frequently
    if opp_defections >= 2:
        return opp_history[-1]
    
    # Late-game: maximize short-term gains
    if current_round >= 8:
        # Check if opponent might defect late
        if "current_round > 7" in opponent_program_code or "round >= 8" in opponent_program_code:
            return "D"
        if current_round == total_rounds:
            return "D"
        return "C" if opp_history[-1] == "C" else "D"
    
    # Default: cooperate if opponent is cooperating
    return "C" if opp_history[-1] == "C" else "D"